!function(mod){"object"==typeof exports&&"object"==typeof module?mod(require("codemirror")):"function"==typeof define&&define.amd?define(["codemirror"],mod):mod(CodeMirror)}(function(CodeMirror){CodeMirror.defineExtension("colorpicker",function(){function dom(tag,className,attr){if("string"!=typeof tag)this.el=tag;else{var el=document.createElement(tag);for(var k in this.uniqId=counter++,el.className=className,attr=attr||{})el.setAttribute(k,attr[k]);this.el=el}}function setRGBInput(r,g,b){$rgb_r.val(r),$rgb_g.val(g),$rgb_b.val(b),$rgb_a.val(currentA)}function setHSLInput(h,s,l){$hsl_h.val(h),$hsl_s.val(s+"%"),$hsl_l.val(l+"%"),$hsl_a.val(currentA)}function getHexFormat(){return color.format({r:$rgb_r.int(),g:$rgb_g.int(),b:$rgb_b.int()},"hex")}function convertRGB(){return color.HSVtoRGB(currentH,currentS,currentV)}function convertHEX(){return color.format(convertRGB(),"hex")}function convertHSL(){var rgb=color.HSVtoRGB(currentH,currentS,currentV);return color.RGBtoHSL(rgb.r,rgb.g,rgb.b)}function getFormattedColor(format){if("rgb"==(format=format||"hex"))return(rgb=convertRGB()).a=1==currentA?void 0:currentA,color.format(rgb,"rgb");if("hsl"==format){var hsl=convertHSL();return hsl.a=1==currentA?void 0:currentA,color.format(hsl,"hsl")}var rgb=convertRGB();return color.format(rgb,"hex")}function setControlColor(color){$controlColor.css("background-color",color)}function setInputColor(){var format=$information.data("format")||"hex",rgb=null;if("hex"==format)$hexCode.val(convertHEX());else if("rgb"==format){setRGBInput((rgb=convertRGB()).r,rgb.g,rgb.b)}else if("hsl"==format){var hsl=convertHSL();setHSLInput(hsl.h,hsl.s,hsl.l)}setControlColor(getFormattedColor("rgb"));rgb=convertRGB();setOpacityColorBar(color.format(rgb,"rgb")),"function"==typeof colorpickerCallback&&(isNaN(currentA)||colorpickerCallback(getFormattedColor(format)))}function setMainColor(e){e.preventDefault();var pos=$root.position(),w=$color.width(),h=$color.height(),x=e.clientX-pos.left,y=e.clientY-pos.top;x<0?x=0:x>w&&(x=w),y<0?y=0:y>h&&(y=h),$drag_pointer.css({left:x-5+"px",top:y-5+"px"}),$drag_pointer.data("pos",{x:x,y:y}),caculateHSV(),setInputColor()}function scale(startColor,endColor,t){var obj={r:parseInt(startColor.r+(endColor.r-startColor.r)*t,10),g:parseInt(startColor.g+(endColor.g-startColor.g)*t,10),b:parseInt(startColor.b+(endColor.b-startColor.b)*t,10)};return color.format(obj,"hex")}function checkHueColor(p){for(var startColor,endColor,i=0;i<hue_color.length;i++)if(hue_color[i].start>=p){startColor=hue_color[i-1],endColor=hue_color[i];break}return startColor&&endColor?scale(startColor,endColor,(p-startColor.start)/(endColor.start-startColor.start)):hue_color[0].rgb}function setBackgroundColor(color){$color.css("background-color",color)}function setCurrentH(h){currentH=h}function setHueColor(e){var dist,min=$hueContainer.offset().left,max=min+$hueContainer.width(),current=e?pos(e).clientX:min+currentH/360*(max-min);dist=current<min?0:current>max?100:(current-min)/(max-min)*100;var x=$hueContainer.width()*(dist/100);$drag_bar.css({left:x-Math.ceil($drag_bar.width()/2)+"px"}),$drag_bar.data("pos",{x:x}),setBackgroundColor(checkHueColor(dist/100)),setCurrentH(dist/100*360),setInputColor()}function getCssValuePrefix(){for(var rtrnVal="",prefixes=["","-o-","-ms-","-moz-","-webkit-"],dom=document.createElement("div"),i=0;i<prefixes.length;i++)dom.style.background=prefixes[i]+"linear-gradient(#000000, #ffffff)",dom.style.background&&(rtrnVal=prefixes[i]);return dom=null,delete dom,rtrnVal}function setOpacityColorBar(hueColor){var rgb=color.parse(hueColor);rgb.a=0;var start=color.format(rgb,"rgb");rgb.a=1;var end=color.format(rgb,"rgb");$opacityColorBar.css("background","linear-gradient(to right, "+start+", "+end+")")}function setOpacity(e){var dist,min=$opacityContainer.offset().left,max=min+$opacityContainer.width(),current=pos(e).clientX;dist=current<min?0:current>max?100:(current-min)/(max-min)*100;var x=$opacityContainer.width()*(dist/100);$opacity_drag_bar.css({left:x-Math.ceil($opacity_drag_bar.width()/2)+"px"}),$opacity_drag_bar.data("pos",{x:x}),caculateOpacity(),currentFormat(),setInputColor()}function caculateOpacity(){var opacityPos=$opacity_drag_bar.data("pos")||{x:0},a=Math.round(opacityPos.x/$opacityContainer.width()*100)/100;currentA=isNaN(a)?1:a}function caculateHSV(){var pos=$drag_pointer.data("pos")||{x:0,y:0},huePos=$drag_bar.data("pos")||{x:0},width=$color.width(),height=$color.height(),h=huePos.x/$hueContainer.width()*360,s=pos.x/width,v=(height-pos.y)/height;0==width&&(h=0,s=0,v=0),currentH=h,currentS=s,currentV=v}function pos(e){return e.touches&&e.touches[0]?e.touches[0]:e}function checkNumberKey(e){var code=e.which,isExcept=!1;return 37!=code&&39!=code&&8!=code&&46!=code&&9!=code||(isExcept=!0),!(!isExcept&&(code<48||code>57))}function setRGBtoHexColor(e){var r=$rgb_r.val(),g=$rgb_g.val(),b=$rgb_b.val();""!=r&&""!=g&&""!=b&&(parseInt(r)>255?$rgb_r.val(255):$rgb_r.val(parseInt(r)),parseInt(g)>255?$rgb_g.val(255):$rgb_g.val(parseInt(g)),parseInt(b)>255?$rgb_b.val(255):$rgb_b.val(parseInt(b)),initColor(getHexFormat()))}function setColorUI(){var x=$color.width()*currentS,y=$color.height()*(1-currentV);$drag_pointer.css({left:x-5+"px",top:y-5+"px"}),$drag_pointer.data("pos",{x:x,y:y});var hueX=$hueContainer.width()*(currentH/360);$drag_bar.css({left:hueX-7.5+"px"}),$drag_bar.data("pos",{x:hueX});var opacityX=$opacityContainer.width()*(currentA||0);$opacity_drag_bar.css({left:opacityX-7.5+"px"}),$opacity_drag_bar.data("pos",{x:opacityX})}function setCurrentHSV(h,s,v,a){currentA=a,currentH=h,currentS=s,currentV=v}function setCurrentFormat(format){$information.data("format",format),initFormat()}function initColor(newColor){var c=newColor||"#FF0000",colorObj=color.parse(c);setCurrentFormat(colorObj.type),setBackgroundColor(c);var hsv=color.RGBtoHSV(colorObj.r,colorObj.g,colorObj.b);setCurrentHSV(hsv.h,hsv.s,hsv.v,colorObj.a),setColorUI(),setHueColor(),setInputColor()}function addEvent(dom,eventName,callback){dom.addEventListener(eventName,callback)}function removeEvent(dom,eventName,callback){dom.removeEventListener(eventName,callback)}function EventColorMouseDown(e){$color.data("isDown",!0),setMainColor(e)}function EventColorMouseUp(e){$color.data("isDown",!1)}function EventDragBarMouseDown(e){e.preventDefault(),$hue.data("isDown",!0)}function EventOpacityDragBarMouseDown(e){e.preventDefault(),$opacity.data("isDown",!0)}function EventHueMouseDown(e){$hue.data("isDown",!0),setHueColor(e)}function EventOpacityMouseDown(e){$opacity.data("isDown",!0),setOpacity(e)}function EventHexCodeKeyDown(e){if(e.which<65||e.which>70)return checkNumberKey(e)}function EventHexCodeKeyUp(e){var code=$hexCode.val();"#"==code.charAt(0)&&7==code.length&&initColor(code)}function EventFormatChangeClick(e){nextFormat()}function initEvent(){addEvent($color.el,"mousedown",EventColorMouseDown),addEvent($color.el,"mouseup",EventColorMouseUp),addEvent($drag_bar.el,"mousedown",EventDragBarMouseDown),addEvent($opacity_drag_bar.el,"mousedown",EventOpacityDragBarMouseDown),addEvent($hueContainer.el,"mousedown",EventHueMouseDown),addEvent($opacityContainer.el,"mousedown",EventOpacityMouseDown),addEvent($hexCode.el,"keydown",EventHexCodeKeyDown),addEvent($hexCode.el,"keyup",EventHexCodeKeyUp),addEvent($rgb_r.el,"keydown",checkNumberKey),addEvent($rgb_r.el,"keyup",setRGBtoHexColor),addEvent($rgb_g.el,"keydown",checkNumberKey),addEvent($rgb_g.el,"keyup",setRGBtoHexColor),addEvent($rgb_b.el,"keydown",checkNumberKey),addEvent($rgb_b.el,"keyup",setRGBtoHexColor),addEvent(document,"mouseup",EventDocumentMouseUp),addEvent(document,"mousemove",EventDocumentMouseMove),addEvent($formatChangeButton.el,"click",EventFormatChangeClick)}function checkColorPickerClass(el){var hasColorView=new dom(el).closest("codemirror-colorview"),hasColorPicker=new dom(el).closest("codemirror-colorpicker"),hasCodeMirror=new dom(el).closest("CodeMirror");el.nodeName;return!!(hasColorPicker||hasColorView||hasCodeMirror)}function checkInHtml(el){return"HTML"==el.nodeName}function EventDocumentMouseUp(e){$color.data("isDown",!1),$hue.data("isDown",!1),$opacity.data("isDown",!1),checkInHtml(e.target)||0==checkColorPickerClass(e.target)&&hide()}function EventDocumentMouseMove(e){$color.data("isDown")&&setMainColor(e),$hue.data("isDown")&&setHueColor(e),$opacity.data("isDown")&&setOpacity(e)}function destroy(){removeEvent($color.el,"mousedown",EventColorMouseDown),removeEvent($color.el,"mouseup",EventColorMouseUp),removeEvent($drag_bar.el,"mousedown",EventDragBarMouseDown),removeEvent($opacity_drag_bar.el,"mousedown",EventOpacityDragBarMouseDown),removeEvent($hueContainer.el,"mousedown",EventHueMouseDown),removeEvent($opacityContainer.el,"mousedown",EventOpacityMouseDown),removeEvent($hexCode.el,"keydown",EventHexCodeKeyDown),removeEvent($hexCode.el,"keyup",EventHexCodeKeyUp),removeEvent($rgb_r.el,"keydown",checkNumberKey),removeEvent($rgb_r.el,"keyup",setRGBtoHexColor),removeEvent($rgb_g.el,"keydown",checkNumberKey),removeEvent($rgb_g.el,"keyup",setRGBtoHexColor),removeEvent($rgb_b.el,"keydown",checkNumberKey),removeEvent($rgb_b.el,"keyup",setRGBtoHexColor),removeEvent(document,"mouseup",EventDocumentMouseUp),removeEvent(document,"mousemove",EventDocumentMouseMove),removeEvent($formatChangeButton.el,"click",EventFormatChangeClick),colorpickerCallback=void 0}function currentFormat(){var current_format=$information.data("format")||"hex";if(currentA<1&&"hex"==current_format){var next_format="rgb";$information.removeClass(current_format),$information.addClass(next_format),$information.data("format",next_format),setInputColor()}}function initFormat(){var current_format=$information.data("format")||"hex";$information.removeClass("hex"),$information.removeClass("rgb"),$information.removeClass("hsl"),$information.addClass(current_format)}function nextFormat(){var current_format=$information.data("format")||"hex",next_format="hex";"hex"==current_format?next_format="rgb":"rgb"==current_format?next_format="hsl":"hsl"==current_format&&(next_format=1==currentA?"hex":"rgb"),$information.removeClass(current_format),$information.addClass(next_format),$information.data("format",next_format),setInputColor()}function makeInputField(type){var item=new dom("div","information-item "+type);if("hex"==type){var field=new dom("div","input-field hex");$hexCode=new dom("input","input",{type:"text"}),field.append($hexCode),field.append(new dom("div","title").html("HEX")),item.append(field)}else if("rgb"==type){field=new dom("div","input-field rgb-r");$rgb_r=new dom("input","input",{type:"text"}),field.append($rgb_r),field.append(new dom("div","title").html("R")),item.append(field),field=new dom("div","input-field rgb-g"),$rgb_g=new dom("input","input",{type:"text"}),field.append($rgb_g),field.append(new dom("div","title").html("G")),item.append(field),field=new dom("div","input-field rgb-b"),$rgb_b=new dom("input","input",{type:"text"}),field.append($rgb_b),field.append(new dom("div","title").html("B")),item.append(field),field=new dom("div","input-field rgb-a"),$rgb_a=new dom("input","input",{type:"text"}),field.append($rgb_a),field.append(new dom("div","title").html("A")),item.append(field)}else if("hsl"==type){field=new dom("div","input-field hsl-h");$hsl_h=new dom("input","input",{type:"text"}),field.append($hsl_h),field.append(new dom("div","title").html("H")),item.append(field),field=new dom("div","input-field hsl-s"),$hsl_s=new dom("input","input",{type:"text"}),field.append($hsl_s),field.append(new dom("div","title").html("S")),item.append(field),field=new dom("div","input-field hsl-l"),$hsl_l=new dom("input","input",{type:"text"}),field.append($hsl_l),field.append(new dom("div","title").html("L")),item.append(field),field=new dom("div","input-field hsl-a"),$hsl_a=new dom("input","input",{type:"text"}),field.append($hsl_a),field.append(new dom("div","title").html("A")),item.append(field)}return item}function init(){$body=new dom(document.body),$root=new dom("div","codemirror-colorpicker"),$color=new dom("div","color"),$drag_pointer=new dom("div","drag-pointer"),$value=new dom("div","value"),$saturation=new dom("div","saturation"),$control=new dom("div","control"),$controlPattern=new dom("div","empty"),$controlColor=new dom("div","color"),$hue=new dom("div","hue"),$hueContainer=new dom("div","hue-container"),$drag_bar=new dom("div","drag-bar"),$opacity=new dom("div","opacity"),$opacityContainer=new dom("div","opacity-container"),$opacityColorBar=new dom("div","color-bar"),$opacity_drag_bar=new dom("div","drag-bar2"),$information=new dom("div","information hex"),$informationChange=new dom("div","information-change"),$formatChangeButton=new dom("button","format-change-button",{type:"button"}).html("↔"),$informationChange.append($formatChangeButton),$information.append(makeInputField("hex")),$information.append(makeInputField("rgb")),$information.append(makeInputField("hsl")),$information.append($informationChange),$value.append($drag_pointer),$saturation.append($value),$color.append($saturation),$hueContainer.append($drag_bar),$hue.append($hueContainer),$opacityContainer.append($opacityColorBar),$opacityContainer.append($opacity_drag_bar),$opacity.append($opacityContainer),$control.append($hue),$control.append($opacity),$control.append($controlPattern),$control.append($controlColor),$root.append($color),$root.append($control),$root.append($information),initHueColors(),initColor()}function initHueColors(){for(var i=0,len=hue_color.length;i<len;i++){var hue=hue_color[i],obj=color.parse(hue.rgb);hue.r=obj.r,hue.g=obj.g,hue.b=obj.b}}function setColor(value){if("object"==typeof value){if(!value.r||!value.g||!value.b)return;initColor(color.format(value,"hex"))}else if("string"==typeof value){if("#"!=value.charAt(0))return;initColor(value)}}function getColor(type){caculateHSV();var rgb=convertRGB();return type?color.format(rgb,type):rgb}function definePostion(opt){var width=$root.width(),height=$root.height(),elementScreenLeft=opt.left-$body.el.scrollLeft;width+elementScreenLeft>window.innerWidth&&(elementScreenLeft-=width+elementScreenLeft-window.innerWidth),elementScreenLeft<0&&(elementScreenLeft=0);var elementScreenTop=opt.top-$body.el.scrollTop;height+elementScreenTop>window.innerHeight&&(elementScreenTop-=height+elementScreenTop-window.innerHeight),elementScreenTop<0&&(elementScreenTop=0),$root.css({left:elementScreenLeft+"px",top:elementScreenTop+"px"})}function show(opt,color,callback){destroy(),initEvent(),$root.appendTo(document.body),$root.css({position:"fixed",left:"-10000px",top:"-10000px"}),$root.show(),definePostion(opt),isColorPickerShow=!0,isShortCut=opt.isShortCut||!1,initColor(color),colorpickerCallback=function(colorString){callback(colorString)},(hideDelay=opt.hideDelay||2e3)>0&&setHideDelay(hideDelay)}function setHideDelay(delayTime){delayTime=delayTime||0,removeEvent($root.el,"mouseenter"),removeEvent($root.el,"mouseleave"),addEvent($root.el,"mouseenter",function(){clearTimeout(timerCloseColorPicker)}),addEvent($root.el,"mouseleave",function(){clearTimeout(timerCloseColorPicker),timerCloseColorPicker=setTimeout(hide,delayTime)}),clearTimeout(timerCloseColorPicker),timerCloseColorPicker=setTimeout(hide,delayTime)}function hide(){isColorPickerShow&&(destroy(),$root.hide(),$root.remove(),isColorPickerShow=!1)}var $body,$root,$hue,$color,$value,$saturation,$drag_pointer,$drag_bar,$control,$controlPattern,$controlColor,$hueContainer,$opacity,$opacityContainer,$opacityColorBar,$formatChangeButton,$opacity_drag_bar,$information,$informationChange,currentA,currentH,currentS,currentV,$hexCode,$rgb_r,$rgb_g,$rgb_b,$rgb_a,$hsl_h,$hsl_s,$hsl_l,$hsl_a,timerCloseColorPicker,color={trim:function(str){return str.replace(/^\s+|\s+$/g,"")},format:function(obj,type){if("hex"==type){var r=obj.r.toString(16);obj.r<16&&(r="0"+r);var g=obj.g.toString(16);obj.g<16&&(g="0"+g);var b=obj.b.toString(16);return obj.b<16&&(b="0"+b),"#"+[r,g,b].join("")}return"rgb"==type?void 0===obj.a?"rgb("+[obj.r,obj.g,obj.b].join(",")+")":"rgba("+[obj.r,obj.g,obj.b,obj.a].join(",")+")":"hsl"==type?void 0===obj.a?"hsl("+[obj.h,obj.s+"%",obj.l+"%"].join(",")+")":"hsla("+[obj.h,obj.s+"%",obj.l+"%",obj.a].join(",")+")":obj},parse:function(str){if("string"==typeof str){if(str.indexOf("rgb(")>-1){for(var i=0,len=(arr=str.replace("rgb(","").replace(")","").split(",")).length;i<len;i++)arr[i]=parseInt(color.trim(arr[i]),10);return{type:"rgb",r:arr[0],g:arr[1],b:arr[2],a:1}}if(str.indexOf("rgba(")>-1){for(i=0,len=(arr=str.replace("rgba(","").replace(")","").split(",")).length;i<len;i++)arr[i]=len-1==i?parseFloat(color.trim(arr[i])):parseInt(color.trim(arr[i]),10);return{type:"rgb",r:arr[0],g:arr[1],b:arr[2],a:arr[3]}}if(str.indexOf("hsl(")>-1){for(i=0,len=(arr=str.replace("hsl(","").replace(")","").split(",")).length;i<len;i++)arr[i]=parseInt(color.trim(arr[i]),10);var obj={type:"hsl",h:arr[0],s:arr[1],l:arr[2],a:1},temp=color.HSLtoRGB(obj.h,obj.s,obj.l);return obj.r=temp.r,obj.g=temp.g,obj.b=temp.b,obj}if(str.indexOf("hsla(")>-1){for(i=0,len=(arr=str.replace("hsla(","").replace(")","").split(",")).length;i<len;i++)arr[i]=len-1==i?parseFloat(color.trim(arr[i])):parseInt(color.trim(arr[i]),10);obj={type:"hsl",h:arr[0],s:arr[1],l:arr[2],a:arr[3]},temp=color.HSLtoRGB(obj.h,obj.s,obj.l);return obj.r=temp.r,obj.g=temp.g,obj.b=temp.b,obj}if(0==str.indexOf("#")){var arr=[];if(3==(str=str.replace("#","")).length)for(i=0,len=str.length;i<len;i++){var char=str.substr(i,1);arr.push(parseInt(char+char,16))}else for(i=0,len=str.length;i<len;i+=2)arr.push(parseInt(str.substr(i,2),16));return{type:"hex",r:arr[0],g:arr[1],b:arr[2],a:1}}}return str},HSVtoRGB:function(H,S,V){360==H&&(H=0);var C=S*V,X=C*(1-Math.abs(H/60%2-1)),m=V-C,temp=[];return 0<=H&&H<60?temp=[C,X,0]:60<=H&&H<120?temp=[X,C,0]:120<=H&&H<180?temp=[0,C,X]:180<=H&&H<240?temp=[0,X,C]:240<=H&&H<300?temp=[X,0,C]:300<=H&&H<360&&(temp=[C,0,X]),{r:Math.ceil(255*(temp[0]+m)),g:Math.ceil(255*(temp[1]+m)),b:Math.ceil(255*(temp[2]+m))}},RGBtoHSV:function(R,G,B){var R1=R/255,G1=G/255,B1=B/255,MaxC=Math.max(R1,G1,B1),DeltaC=MaxC-Math.min(R1,G1,B1),H=0;0==DeltaC?H=0:MaxC==R1?H=(G1-B1)/DeltaC%6*60:MaxC==G1?H=60*((B1-R1)/DeltaC+2):MaxC==B1&&(H=60*((R1-G1)/DeltaC+4)),H<0&&(H=360+H);return{h:H,s:0==MaxC?0:DeltaC/MaxC,v:MaxC}},RGBtoHSL:function(r,g,b){r/=255,g/=255,b/=255;var h,s,max=Math.max(r,g,b),min=Math.min(r,g,b),l=(max+min)/2;if(max==min)h=s=0;else{var d=max-min;switch(s=l>.5?d/(2-max-min):d/(max+min),max){case r:h=(g-b)/d+(g<b?6:0);break;case g:h=(b-r)/d+2;break;case b:h=(r-g)/d+4}h/=6}return{h:Math.round(360*h),s:Math.round(100*s),l:Math.round(100*l)}},HUEtoRGB:function(p,q,t){return t<0&&(t+=1),t>1&&(t-=1),t<1/6?p+6*(q-p)*t:t<.5?q:t<2/3?p+(q-p)*(2/3-t)*6:p},HSLtoRGB:function(h,s,l){var r,g,b;if(h/=360,l/=100,0==(s/=100))r=g=b=l;else{var q=l<.5?l*(1+s):l+s-l*s,p=2*l-q;r=this.HUEtoRGB(p,q,h+1/3),g=this.HUEtoRGB(p,q,h),b=this.HUEtoRGB(p,q,h-1/3)}return{r:255*r,g:255*g,b:255*b}}},hue_color=[{rgb:"#ff0000",start:0},{rgb:"#ffff00",start:.17},{rgb:"#00ff00",start:.33},{rgb:"#00ffff",start:.5},{rgb:"#0000ff",start:.67},{rgb:"#ff00ff",start:.83},{rgb:"#ff0000",start:1}],colorpickerCallback=(getCssValuePrefix(),function(){}),counter=0,cached={},isColorPickerShow=!1,isShortCut=!1,hideDelay=2e3;return dom.prototype.closest=function(cls){for(var temp=this,checkCls=!1;!(checkCls=temp.hasClass(cls));){if(!temp.el.parentNode)return null;temp=new dom(temp.el.parentNode)}return checkCls?temp:null},dom.prototype.removeClass=function(cls){this.el.className=color.trim((" "+this.el.className+" ").replace(" "+cls+" "," "))},dom.prototype.hasClass=function(cls){return!!this.el.className&&(" "+this.el.className+" ").indexOf(" "+cls+" ")>-1},dom.prototype.addClass=function(cls){this.hasClass(cls)||(this.el.className=this.el.className+" "+cls)},dom.prototype.html=function(html){return this.el.innerHTML=html,this},dom.prototype.empty=function(){return this.html("")},dom.prototype.append=function(el){return"string"==typeof el?this.el.appendChild(document.createTextNode(el)):this.el.appendChild(el.el||el),this},dom.prototype.appendTo=function(target){return(target.el?target.el:target).appendChild(this.el),this},dom.prototype.remove=function(){return this.el.parentNode&&this.el.parentNode.removeChild(this.el),this},dom.prototype.text=function(){return this.el.textContent},dom.prototype.css=function(key,value){if(2==arguments.length)this.el.style[key]=value;else if(1==arguments.length){if("string"==typeof key)return getComputedStyle(this.el)[key];var keys=key||{};for(var k in keys)this.el.style[k]=keys[k]}return this},dom.prototype.offset=function(){var rect=this.el.getBoundingClientRect();return{top:rect.top+document.body.scrollTop,left:rect.left+document.body.scrollLeft}},dom.prototype.position=function(){return{top:parseFloat(this.el.style.top),left:parseFloat(this.el.style.left)}},dom.prototype.width=function(){return this.el.offsetWidth},dom.prototype.height=function(){return this.el.offsetHeight},dom.prototype.dataKey=function(key){return this.uniqId+"."+key},dom.prototype.data=function(key,value){if(2!=arguments.length){if(1==arguments.length)return cached[this.dataKey(key)];var keys=Object.keys(cached),uniqId=this.uniqId+".";return keys.filter(function(key){return 0==key.indexOf(uniqId)}).map(function(value){return cached[value]})}return cached[this.dataKey(key)]=value,this},dom.prototype.val=function(value){return 0==arguments.length?this.el.value:(1==arguments.length&&(this.el.value=value),this)},dom.prototype.int=function(){return parseInt(this.val(),10)},dom.prototype.show=function(){return this.css("display","block")},dom.prototype.hide=function(){return this.css("display","none")},init(),{isShortCut:function(){return isShortCut},$root:$root,show:show,hide:hide,setColor:setColor,getColor:getColor}})});